# Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
import tensorflow as tf

class Tensor(tf.Tensor):
    def abs(x, name=None) -> Tensor: ...
    def acos(x, name=None) -> Tensor: ...
    def acosh(x, name=None) -> Tensor: ...
    def add(x, y, name=None) -> Tensor: ...
    def angle(input, name=None) -> Tensor: ...
    def argmax(input, axis=None, name=None, dimension=None, output_type=tf.int64) -> Tensor: ...
    def argmin(input, axis=None, name=None, dimension=None, output_type=tf.int64) -> Tensor: ...
    def asin(x, name=None) -> Tensor: ...
    def asinh(x, name=None) -> Tensor: ...
    def atan(x, name=None) -> Tensor: ...
    def atan2(y, x, name=None) -> Tensor: ...
    def atanh(x, name=None) -> Tensor: ...
    def betainc(a, b, x, name=None) -> Tensor: ...
    def cast(x, dtype, name=None) -> Tensor: ...
    def ceil(x, name=None) -> Tensor: ...
    def check_numerics(tensor, message, name=None) -> Tensor: ...
    def clip_by_average_norm(t, clip_norm, name=None) -> Tensor: ...
    def clip_by_norm(t, clip_norm, axes=None, name=None) -> Tensor: ...
    def clip_by_value(t, clip_value_min, clip_value_max, name=None) -> Tensor: ...
    def complex(real, imag, name=None) -> Tensor: ...
    def conj(x, name=None) -> Tensor: ...
    def cos(x, name=None) -> Tensor: ...
    def cosh(x, name=None) -> Tensor: ...
    def cross(a, b, name=None) -> Tensor: ...
    def cumprod(x, axis=0, exclusive=False, reverse=False, name=None) -> Tensor: ...
    def cumsum(x, axis=0, exclusive=False, reverse=False, name=None) -> Tensor: ...
    def dequantize(input, min_range, max_range, mode='MIN_COMBINED', name=None) -> Tensor: ...
    def diag(diagonal, name=None) -> Tensor: ...
    def digamma(x, name=None) -> Tensor: ...
    def div(x, y, name=None) -> Tensor: ...
    def equal(x, y, name=None) -> Tensor: ...
    def erf(x, name=None) -> Tensor: ...
    def erfc(x, name=None) -> Tensor: ...
    def exp(x, name=None) -> Tensor: ...
    def expand_dims(input, axis=None, name=None, dim=None) -> Tensor: ...
    def expm1(x, name=None) -> Tensor: ...
    def fill(dims, value, name=None) -> Tensor: ...
    def floor(x, name=None) -> Tensor: ...
    def floor_div(x, y, name=None) -> Tensor: ...
    def floordiv(x, y, name=None) -> Tensor: ...
    def floormod(x, y, name=None) -> Tensor: ...
    def gather(params, indices, validate_indices=None, name=None, axis=0) -> Tensor: ...
    def gather_nd(params, indices, name=None) -> Tensor: ...
    def greater(x, y, name=None) -> Tensor: ...
    def greater_equal(x, y, name=None) -> Tensor: ...
    def hessians(ys, xs, name='hessians', colocate_gradients_with_ops=False, gate_gradients=False, aggregation_method=None) -> Tensor: ...
    def identity(input, name=None) -> Tensor: ...
    def igamma(a, x, name=None) -> Tensor: ...
    def igammac(a, x, name=None) -> Tensor: ...
    def imag(input, name=None) -> Tensor: ...
    def is_finite(x, name=None) -> Tensor: ...
    def is_inf(x, name=None) -> Tensor: ...
    def is_nan(x, name=None) -> Tensor: ...
    def less(x, y, name=None) -> Tensor: ...
    def less_equal(x, y, name=None) -> Tensor: ...
    def lgamma(x, name=None) -> Tensor: ...
    def log(x, name=None) -> Tensor: ...
    def log1p(x, name=None) -> Tensor: ...
    def logical_and(x, y, name=None) -> Tensor: ...
    def logical_not(x, name=None) -> Tensor: ...
    def logical_or(x, y, name=None) -> Tensor: ...
    def matmul(a, b, transpose_a=False, transpose_b=False, adjoint_a=False, adjoint_b=False, a_is_sparse=False, b_is_sparse=False, name=None) -> Tensor: ...
    def maximum(x, y, name=None) -> Tensor: ...
    def meshgrid(*args, **kwargs) -> Tensor: ...
    def minimum(x, y, name=None) -> Tensor: ...
    def mod(x, y, name=None) -> Tensor: ...
    def mul(x, y, name=None) -> Tensor: ...
    def multiply(x, y, name=None) -> Tensor: ...
    def negative(x, name=None) -> Tensor: ...
    def norm(tensor, ord='euclidean', axis=None, keepdims=None, name=None) -> Tensor: ...
    def not_equal(x, y, name=None) -> Tensor: ...
    def one_hot(indices, depth, on_value=None, off_value=None, axis=None, dtype=None, name=None) -> Tensor: ...
    def ones_like(tensor, dtype=None, name=None, optimize=True) -> Tensor: ...
    def pad(tensor, paddings, mode='CONSTANT', name=None, constant_values=0) -> Tensor: ...
    def polygamma(a, x, name=None) -> Tensor: ...
    def pow(x, y, name=None) -> Tensor: ...
    def quantize(input, min_range, max_range, T, mode='MIN_COMBINED', round_mode='HALF_AWAY_FROM_ZERO', name=None) -> Tensor: ...
    def real(input, name=None) -> Tensor: ...
    def realdiv(x, y, name=None) -> Tensor: ...
    def reciprocal(x, name=None) -> Tensor: ...
    def reduce_all(input_tensor, axis=None, keepdims=None, name=None, reduction_indices=None) -> Tensor: ...
    def reduce_any(input_tensor, axis=None, keepdims=None, name=None, reduction_indices=None) -> Tensor: ...
    def reduce_logsumexp(input_tensor, axis=None, keepdims=None, name=None, reduction_indices=None) -> Tensor: ...
    def reduce_max(input_tensor, axis=None, keepdims=None, name=None, reduction_indices=None) -> Tensor: ...
    def reduce_mean(input_tensor, axis=None, keepdims=None, name=None, reduction_indices=None) -> Tensor: ...
    def reduce_min(input_tensor, axis=None, keepdims=None, name=None, reduction_indices=None) -> Tensor: ...
    def reduce_prod(input_tensor, axis=None, keepdims=None, name=None, reduction_indices=None) -> Tensor: ...
    def reduce_sum(input_tensor, axis=None, keepdims=None, name=None, reduction_indices=None) -> Tensor: ...
    def reshape(tensor, shape, name=None) -> Tensor: ...
    def reverse(tensor, axis, name=None) -> Tensor: ...
    def rint(x, name=None) -> Tensor: ...
    def round(x, name=None) -> Tensor: ...
    def rsqrt(x, name=None) -> Tensor: ...
    def scatter_nd(indices, updates, shape, name=None) -> Tensor: ...
    def sign(x, name=None) -> Tensor: ...
    def sin(x, name=None) -> Tensor: ...
    def sinh(x, name=None) -> Tensor: ...
    def size(input, name=None, out_type=tf.int32) -> Tensor: ...
    def slice(input_, begin, size, name=None) -> Tensor: ...
    def sqrt(x, name=None) -> Tensor: ...
    def square(x, name=None) -> Tensor: ...
    def squeeze(input, axis=None, name=None, squeeze_dims=None) -> Tensor: ...
    def stop_gradient(input, name=None) -> Tensor: ...
    def sub(x, y, name=None) -> Tensor: ...
    def subtract(x, y, name=None) -> Tensor: ...
    def tan(x, name=None) -> Tensor: ...
    def tensordot(a, b, axes, name=None) -> Tensor: ...
    def tile(input, multiples, name=None) -> Tensor: ...
    def to_bfloat16(x, name='ToBFloat16') -> Tensor: ...
    def to_complex128(x, name='ToComplex128') -> Tensor: ...
    def to_complex64(x, name='ToComplex64') -> Tensor: ...
    def to_double(x, name='ToDouble') -> Tensor: ...
    def to_float(x, name='ToFloat') -> Tensor: ...
    def to_int32(x, name='ToInt32') -> Tensor: ...
    def to_int64(x, name='ToInt64') -> Tensor: ...
    def transpose(a, perm=None, name='transpose', conjugate=False) -> Tensor: ...
    def truediv(x, y, name=None) -> Tensor: ...
    def truncatediv(x, y, name=None) -> Tensor: ...
    def truncatemod(x, y, name=None) -> Tensor: ...
    def unique(x, out_idx=tf.int32, name=None) -> Tensor: ...
    def where(condition, x=None, y=None, name=None) -> Tensor: ...
    def zeros_like(tensor, dtype=None, name=None, optimize=True) -> Tensor: ...
    def zeta(x, q, name=None) -> Tensor: ...

    def __add__(self, other) -> Tensor: ...
    def __sub__(self, other) -> Tensor: ...
    def __mul__(self, other) -> Tensor: ...
    def __rdiv__(self, other) -> Tensor: ...
    def __itruediv__(self, other) -> Tensor: ...
    def __rsub__(self, other) -> Tensor: ...
    def __isub__(self, other) -> Tensor: ...
    def __imul__(self, other) -> Tensor: ...
    def __rmul__(self, other) -> Tensor: ...
    def __radd__(self, other) -> Tensor: ...